---
name: llm-cost-analysis
description: Analyze and compare LLM API pricing across providers (OpenAI, Anthropic, Google, Mistral, etc.). Use when users ask about LLM costs, token pricing comparisons, cost estimation for AI projects, budget planning for API usage, or need interactive cost calculators. Supports URL-based state encoding for shareable comparisons.
---

# LLM Cost Analysis Skill

Calculate, compare, and visualize LLM API costs across major providers.

## Core Capabilities

1. **Cost Estimation** - Calculate costs for specific token volumes
2. **Model Comparison** - Side-by-side pricing analysis
3. **Interactive Reports** - Generate shareable HTML calculators
4. **URL State Encoding** - Create bookmarkable comparison URLs

## URL State Pattern

Generate shareable URLs using fragment-based state encoding:

```
https://example.com/llm-prices/#it=INPUT_TOKENS&ot=OUTPUT_TOKENS&ic=INPUT_COST&cic=CACHED_COST&oc=OUTPUT_COST&sel=MODEL1,MODEL2
```

| Parameter | Description | Example |
|-----------|-------------|---------|
| `it` | Input tokens | 1000000000 (1B) |
| `ot` | Output tokens | 1000000 (1M) |
| `ic` | Input cost threshold ($/1M) | 0.3 |
| `cic` | Cached input cost ($/1M) | 0.03 |
| `oc` | Output cost threshold ($/1M) | 2.5 |
| `sel` | Selected models (comma-sep) | claude-3-haiku,gpt-4o-mini |

## Quick Cost Formula

```
Total Cost = (input_tokens × input_price / 1M) + (output_tokens × output_price / 1M)
```

For cached contexts: use `cic` rate for repeated prompts.

## Workflow

### Simple Cost Query
User asks "How much would 1M input + 100K output cost with Claude Sonnet?"
→ Look up pricing in `references/pricing-data.md`
→ Calculate: (1M × $3.00 / 1M) + (100K × $15.00 / 1M) = $4.50

### Comparison Report
User asks "Compare costs for my chatbot across providers"
→ Run `scripts/cost_calculator.py` with parameters
→ Generate HTML report using `scripts/generate_comparison.py`

### Interactive Calculator
User asks "Create a shareable LLM cost calculator"
→ Use `assets/comparison-template.html` as base
→ Customize with user's models and defaults

## Scripts

- `scripts/cost_calculator.py` - CLI tool for batch cost calculations
- `scripts/generate_comparison.py` - Generate standalone HTML comparison reports

## Reference Data

See `references/pricing-data.md` for current pricing (update periodically as prices change).

## Output Formats

1. **Markdown table** - Quick inline comparisons
2. **JSON** - Programmatic integration
3. **HTML** - Interactive shareable calculators
4. **URL** - Bookmarkable state links
