# LLM Provider Reference

Detailed configuration for each supported LLM provider.

## Provider Configurations

### OpenAI
- **Endpoint**: `https://api.openai.com/v1/chat/completions`
- **Auth**: `Authorization: Bearer $OPENAI_API_KEY`
- **Models**: `gpt-4o`, `gpt-4o-mini`, `gpt-4-turbo`
- **Max tokens param**: `max_completion_tokens`

### Anthropic Claude
- **Endpoint**: `https://api.anthropic.com/v1/messages`
- **Auth**: `x-api-key: $ANTHROPIC_API_KEY` (NOT Bearer token)
- **Header**: `anthropic-version: 2023-06-01`
- **Models**: `claude-sonnet-4-20250514`, `claude-opus-4-5-20251101`, `claude-sonnet-4-5-20250929`
- **Max tokens param**: `max_tokens`

### Google Gemini
- **Endpoint**: `https://generativelanguage.googleapis.com/v1beta/chat/completions`
- **Auth**: `Authorization: Bearer $GOOGLE_API_KEY`
- **Models**: `gemini-3-flash-preview`, `gemini-3-pro-preview`, `gemini-2.5-flash`, `gemini-2.5-pro`
- **Max tokens param**: `max_tokens`

### xAI Grok
- **Endpoint**: `https://api.x.ai/v1/chat/completions`
- **Auth**: `Authorization: Bearer $XAI_API_KEY`
- **Models**: `grok-2`, `grok-beta`
- **Max tokens param**: `max_tokens`

### Mistral
- **Endpoint**: `https://api.mistral.ai/v1/chat/completions`
- **Auth**: `Authorization: Bearer $MISTRAL_API_KEY`
- **Models**: `mistral-large-latest`, `mistral-small-latest`
- **Max tokens param**: `max_tokens`

### Ollama (Local)
- **Endpoint**: `http://localhost:11434/v1/chat/completions`
- **Auth**: None required
- **Models**: Any model loaded in Ollama (e.g., `llama2`, `mistral`, `neural-chat`)
- **Max tokens param**: `max_tokens`

### LM Studio (Local)
- **Endpoint**: `http://localhost:1234/v1/chat/completions`
- **Auth**: None required
- **Models**: Any model loaded in LM Studio
- **Max tokens param**: `max_tokens`

## Model Name Formats

**Important**: Model names must be exact. Common errors:

| Wrong | Correct |
|-------|---------|
| `claude-4-5-sonnet` | `claude-sonnet-4-20250514` |
| `gemini-3.0-flash` | `gemini-3-flash-preview` |
| `gpt-4` | `gpt-4o` or `gpt-4-turbo` |

## API Authentication Differences

| Provider | Auth Method |
|----------|-------------|
| OpenAI, Grok, Mistral, Gemini | `Authorization: Bearer <key>` |
| Claude | `x-api-key: <key>` |
| Ollama, LM Studio | No auth required |

## Troubleshooting

### 404 Not Found
- Usually wrong model name
- Use `--list-providers` to see defaults
- Check model name format above

### 401 Unauthorized
- Check API key is set correctly
- Verify environment variable name

### 400 Bad Request
- Check request payload format
- May be wrong endpoint for provider
