---
name: virtuoso-spin-rule-generator
description: Generate Virtuoso SPIN-based inference rules from SPARQL queries
license: MIT
---

# Virtuoso SPIN Inference Rule Generator

Generate OpenLink Virtuoso SPIN-based custom inference rules from SPARQL queries.

## Commands

### /spin-rule-gen

Generate complete `.sql` files containing SPIN macro libraries that enable runtime inference over RDF data in Virtuoso.

**What it does:**
- Analyzes SPARQL queries to extract classification patterns
- Converts SELECT queries to CONSTRUCT-based inference rules
- Generates complete 6-section SPIN rule files
- Includes preflight tests, macro generation, and inference validation
- Creates production-ready code following Virtuoso best practices

**Input formats:**
1. **File reference**: "Generate SPIN rules from customer-analysis.rq"
2. **Direct SPARQL**: Paste query for conversion
3. **Natural language**: "Create a rule for companies with 100+ orders"

**Example usage:**

```
/spin-rule-gen Generate SPIN rules from customer-analysis.rq
```

```
/spin-rule-gen Create a rule that classifies products as "BestSeller"
if ordered more than 1000 times in the last year
```

```
/spin-rule-gen Convert this query to a SPIN rule:

PREFIX ecrm: <http://www.openlinksw.com/ontology/ecrm#>
PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>

SELECT DISTINCT ?company ?mostRecentOrderDate
WHERE {
  {
    SELECT ?company (MAX(?orderDate) AS ?mostRecentOrderDate)
    WHERE {
      ?order a ecrm:Order ;
             ecrm:hasCompany ?company ;
             ecrm:orderDate ?orderDate .
      FILTER (datatype(?orderDate) IN (xsd:date, xsd:dateTime))
    }
    GROUP BY ?company
  }
  FILTER (?mostRecentOrderDate <= (NOW() - "P2Y"^^xsd:duration))
}
```

**Output structure:**

The skill generates a complete `.sql` file with:

1. **Header**: Description and metadata
2. **Housekeeping**: `SPARQL CLEAR GRAPH` and `DROP SPIN LIBRARY` commands
3. **Preflight Controls**: Validation SELECT queries to verify data exists
4. **TTLP Section**: Turtle-based OWL class definitions and SPIN rules
5. **Macro Generation**: `SPARQL_SPIN_GRAPH_TO_DEFSPIN()` compilation
6. **Inference Tests**: Positive (with DEFINE) and negative (without) test queries

**Requirements:**
- OpenLink Virtuoso 8.0 or later
- Basic SPARQL knowledge
- RDF data loaded in Virtuoso instance

**Use cases:**
- Customer segmentation (active, at-risk, dormant, inactive)
- Product classification (best-seller, discontinued, seasonal)
- Entity lifecycle tracking (new, established, legacy)
- Threshold-based rules (high-value, premium, VIP)
- Temporal analysis (recent, aging, expired)
- Multi-criteria classifications combining multiple conditions

**Version:** 1.0.0
**Author:** OpenLink Software
**Category:** Data Engineering
**Tags:** virtuoso, sparql, inference, spin, rdf, knowledge-graph, semantic-web
